﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Model;
using IndianHealthService.BMXNet.Ado;
using System.Data;

namespace IndianHealthService.BMXNet.Services
{
    public class BMXNetPooledSession:RemoteSession
    {

        public BMXNetPooledSession(RemoteSession aSession)
        {
            this.Session = aSession;
        }

        private RemoteSession _session;

        protected RemoteSession Session
        {
            get { return _session; }
            set { _session = value; }
        }

        #region BMXNetSession Members

        public string HostAddress
        {
            get { return this.Session.HostAddress; }
        }

        public string UserName
        {
            get { return this.Session.UserName; }
        }

        public string DUZ
        {
            get { return this.Session.DUZ; }
        }

        public string TransmitRPC(string rpcCommand, string rpcParameter, string context)
        {
            return this.Session.TransmitRPC(rpcCommand, rpcParameter, context);
        }

        public string SafelyTransmitRPC(string rpcCommand, string rpcParameter, string context)
        {
            return this.Session.SafelyTransmitRPC(rpcCommand, rpcParameter, context);
        }

        public string RpcResult
        {
            get { return this.Session.RpcResult; }
        }

        public string DebugLastResult
        {
            get { return this.Session.DebugLastResult;  }
        }

        public DataTable VersionInfo
        {

            get {  return this.Session.VersionInfo; }
        }

        public string DebugLastRpcSignature
        {
            get { return this.Session.DebugLastRpcSignature; }
        }

        public bool IsTableGenerationRpc(string aString)
        {
            return this.Session.IsTableGenerationRpc(aString);
        }

        public System.Data.DataTable TransmitTableGenerationRPC(string generationString)
        {
            return this.Session.TransmitTableGenerationRPC(generationString);
        }

        public System.Data.DataTable TransmitTableGenerationRPC(string generationString, System.Data.DataSet aDataSet)
        {
            return this.Session.TransmitTableGenerationRPC(generationString, aDataSet);
        }

        public System.Data.DataTable TableFromRPC(string rpcCommand, string rpcParameter, string context)
        {
            return this.Session.TableFromRPC(rpcCommand, rpcParameter, context);
        }

        public System.Data.DataTable TableFromRPC(string rpcCommand, string rpcParameter, string context, System.Data.DataSet aDataSet)
        {
            return this.Session.TableFromRPC(rpcCommand, rpcParameter, context, aDataSet);
        }

        public System.Data.DataTable TableFromSQL(string sql)
        {
            return this.Session.TableFromSQL(sql);
        }

        public bool SaveChanges(System.Data.DataTable aDataTable)
        {
            return this.Session.SaveChanges(aDataTable);
        }

        public void Close()
        {
            ///TODO: implement pool behavior.  Current behavior is simple reuse
        }

        #endregion

    

        public string AppContext
        {
            get
            {
                return this.Session.AppContext;
            }
            set
            {
                this.Session.AppContext = value;
            }
        }

        public string TransmitRPC(string rpcCommand, string rpcParameter)
        {
            return this.TransmitRPC(rpcCommand, rpcParameter, this.AppContext);
        }

        public string SafelyTransmitRPC(string rpcCommand, string rpcParameter)
        {
            return this.SafelyTransmitRPC(rpcCommand, rpcParameter, this.AppContext);
        }

        public System.Data.DataTable TableFromRPC(string rpcCommand, string rpcParameter)
        {
            return this.TableFromRPC(rpcCommand, rpcParameter, this.AppContext);
        }

        public System.Data.DataTable TableFromRPC(string rpcCommand, string rpcParameter, System.Data.DataSet aDataSet)
        {
            return this.TableFromRPC(rpcCommand, rpcParameter, aDataSet);
        }


        #region BMXNetSession Members


        public DataTableFuture AsyncTableFromRPC(string rpcCommand, string rpcParameter)
        {
            throw new NotImplementedException();
        }

        public DataTableFuture AsyncTableFromRPC(string rpcCommand, string rpcParameter, System.Data.DataSet aDataSet)
        {
            throw new NotImplementedException();
        }

        public DataTableFuture AsyncTableFromRPC(string rpcCommand, string rpcParameter, string context)
        {
            throw new NotImplementedException();
        }

        public DataTableFuture AsyncTableFromRPC(string rpcCommand, string rpcParameter, string context, System.Data.DataSet aDataSet)
        {
            throw new NotImplementedException();
        }

        public event EventHandler<RemoteEventArgs> RemoteEvent;

        #endregion

        #region BMXNetSession Members


        public System.Data.DataTable TransmitTableGenerationRPC(string generationString, System.Data.DataSet aDataSet, string aTableName)
        {
            throw new NotImplementedException();
        }

        public RemoteEventService EventServices
        {
            get { return this.Session.EventServices; }
        }

        #endregion

   

        public System.Data.DataTable TableFromSQL(string sql, System.Data.DataSet aDataSet)
        {
            return this.Session.TableFromSQL(sql, aDataSet);
        }

        public System.Data.DataTable TableFromSQL(string sql, System.Data.DataSet aDataSet, string aTableName)
        {
            return this.Session.TableFromSQL(sql, aDataSet,aTableName);
        }

    }
}
